# シミュレーション

シミュレーションを使うと、実際の農場の状態を変えずに、コードを素早くテストできます。
シミュレーションの開始状態は自由に選べます。シミュレーションが終わると、実際の農場はシミュレーション開始前と全く同じ状態に戻ります。

`simulate()` 関数は、シミュレーションを開始するために使用されます。

実行を開始するファイル
`filename = "f1"`

すべてをアンロックし、完全にアップグレードした状態で開始
`sim_unlocks = Unlocks`

ニンジン10000個と干し草50個で開始
`sim_items = {Items.Carrot : 10000, Items.Hay : 50}`

値が13のグローバル変数 "a" を持って開始
`sim_globals = {"a" : 13}`

固定のランダムシードを使用
`seed = 0`

シミュレーションを64倍速に
`speedup = 64`

シミュレーションを実行
`run_time = simulate(filename, sim_unlocks, sim_items, sim_globals, seed, speedup)`

`simulate()` 関数は、指定された開始ファイルのシミュレーションにかかった時間を秒単位で返します。

### ファイル名
simulate関数の最初の引数はファイル名です。これはコードウィンドウの上部に表示される名前です。シミュレーションは、指定されたファイルの実行ボタンをクリックしたかのように実行されます。

### 開始時のアンロック
ループ、if文、リスト、辞書などのすべてのプログラミング機能は、常にアンロックされたままです。

2番目の引数では、プログラミング機能に加えて、シミュレーションを開始する際のアンロック/アップグレードを指定できます。これはアンロックのシーケンスである必要があります。シミュレーションは、シーケンス内のすべてのアンロックが最大レベルまでアップグレードされた状態で開始されます。

最大以外のアップグレードレベルを指定したい場合は、アンロックをアンロックレベルにマッピングする辞書を渡すことができます。この場合、負の値は最大のアンロックレベルに対応します。

### 開始時のアイテム
3番目の引数では、アイテムを数値にマッピングする辞書を渡すことができます。これはシミュレーションを開始する際のアイテムを指定します。

### 開始時のグローバル変数
シミュレーションは完全に新しいプログラム実行を開始するため、シミュレーションを開始するプログラムから変数にアクセスすることはできません。
ただし、4番目の引数を使用してシミュレーションに値を渡すことは可能です。これは、文字列形式の変数名を値にマッピングする辞書です。これらの変数は、シミュレーション内の実行のグローバルスコープに追加されます。

これはすべての値をコピーするため、シミュレーション内で値を変更しても、シミュレーション外の元の値には影響しないことに注意してください。実行にかかった時間以外にシミュレーションから値を返すことはできません。

### ランダムシード
5番目の引数では、シミュレーションで使用されるランダムシードを指定できます。これは正の整数でなければなりません。負の値を指定すると、ランダムなシードが使用されます。

ランダムシードは、植物の成長時間から迷路のレイアウト、水の減少時間まで、あらゆるものに影響します。同じランダムシードと開始条件で同じシミュレーションを複数回開始した場合、結果は常に同じになるはずです。

### スピードアップ
6番目の引数は、シミュレーションの開始時のスピードアップです。これにより、物事を素早くテストできます。ゲームが設定された速度に追いつけない場合は、自動的に速度が低下します。

スピードアップは、シミュレーションの結果に何ら影響を与えません。これは待ち時間を短縮するためだけに存在します。